<?php

error_reporting(E_ALL);
ini_set("display_errors","1");

// Mod added to make sure nobody requests index.php as we allow that through the holding page
// so that we can still access the admin area with the public site being on the holding page.
if ($_SERVER['REQUEST_URI']=='/index.php') { // User requested this directly! We don't allow that!
	Header("Location: /");
	exit;
}

ob_start();

try {

	require_once(getcwd()."/sys/init.php");
	require_once(getcwd().'/sys/smarty.php');

	$rewrite = new Kicomoco_Model_Rewrite($mysqli);

	$args = $rewrite->route();

	if ($args) {

		$controllerFile = getcwd()."/sys/module/{$args['strModule']}/controller/{$args['strController']}.php";
		if (file_exists($controllerFile) && is_file($controllerFile)) {
			$controllerName = "{$args['strModule']}_Controller_{$args['strController']}";
			require_once($controllerFile);
			$controller = new $controllerName($mysqli, $smarty, $args['strController'], $args['strAction']);
		} else {
			throw new InvalidControllerException("Invalid controller (Module: {$args['strModule']}, Controller: {$args['strController']})");
		}

		$actionMethod = $args['strAction'].'Action';
		
		if (method_exists($controller,$actionMethod)) {
			$actionResults = $controller->$actionMethod($args['strArgs']);
		} else {
			throw new InvalidActionException("Invalid action (Module: {$args['strModule']}, Controller: {$args['strController']}, Action: {$args['strAction']}");
		}

		$smarty->assign('basics',$actionResults['basics']);
		
		foreach ($actionResults['args'] as $key=>$val) $smarty->assign($key,$val);

		$smarty->assign('template',$actionResults['template']);

		$smarty->display($actionResults['layout']);
		
	} else {

		//throw new HTTP404Exception('Error 404, '.$_SERVER['REQUEST_URI']);
		$smarty->assign('template','404.tpl');
		
		require_once(getcwd()."/sys/module/kicomoco/model/product_category.php");
		$categories = new Kicomoco_Model_Product_Category($mysqli);
		$smarty->assign('categories',$categories->where('bolDeleted=0'));
		
		$smarty->display('public/layout.tpl');

	}

} catch (Exception $e) {

	ob_clean();

	echo '<pre>';
	var_dump($e);
	die;

	include('oops.html');

}