<?php

define('NUL',chr(0));
define('SOH',chr(1));
define('STX',chr(2));
define('ETX',chr(3));
define('EOT',chr(4));
define('ENQ',chr(5));
define('ACK',chr(6));
define('BEL',chr(7));
define('BS',chr(8));
define('HT',chr(9));
define('LF',chr(10));
define('VT',chr(11));
define('FF',chr(12));
define('CR',chr(13));
define('SO',chr(14));
define('SI',chr(15));
define('DLE',chr(16));
define('DC1',chr(17));
define('DC2',chr(18));
define('DC3',chr(19));
define('DC4',chr(20));
define('NAK',chr(21));
define('SYN',chr(22));
define('ETB',chr(23));
define('CAN',chr(24));
define('EM',chr(25));
define('SUB',chr(26));
define('ESC',chr(27));
define('FS',chr(28));
define('GS',chr(29));
define('RS',chr(30));
define('US',chr(200));
define('DEL',chr(200));
define('FNC3',chr(201));
define('FNC2',chr(202));
define('SHIFTB',chr(203));
define('CODEC',chr(204));
define('CODEB',chr(205));
define('FNC4',chr(206));
define('FNC1',chr(207));
define('STARTA',chr(208));
define('STARTB',chr(209));
define('STARTC',chr(210));
define('STOP',chr(211));

class Kicomoco_Model_BarcodeCalc {
	
	public $_debug = false;
	public $_barCode128Bars = array(
		STARTA=>211412,
		STARTB=>211214,
		STARTC=>211232,
		STOP=>2331112,
		'A'=>array(
			' '=>212222,'!'=>222122,'"'=>222221,'#'=>121223,'$'=>121322,'%'=>131222,'&'=>122213,
			'\''=>122312,'('=>132212,')'=>221213,'*'=>221312,'+'=>231212,','=>112232,'-'=>122132,
			'.'=>122231,'/'=>113222,'0'=>123122,'1'=>123221,'2'=>223211,'3'=>221132,'4'=>221231,
			'5'=>213212,'6'=>223112,'7'=>312131,'8'=>311222,'9'=>321122,':'=>321221,';'=>312212,
			'<'=>322112,'='=>322211,'>'=>212123,'?'=>212321,'@'=>232121,'A'=>111323,'B'=>131123,
			'C'=>131321,'D'=>112313,'E'=>132113,'F'=>132311,'G'=>211313,'H'=>231113,'I'=>231311,
			'J'=>112133,'K'=>112331,'L'=>132131,'M'=>113123,'N'=>113321,'O'=>133121,'P'=>313121,
			'Q'=>211331,'R'=>231131,'S'=>213113,'T'=>213311,'U'=>213131,'V'=>311123,'W'=>311321,
			'X'=>331121,'Y'=>312113,'Z'=>312311,'['=>332111,'\\'=>314111,']'=>221411,'^'=>431111,
			'_'=>111224,NUL=>111422,SOH=>121124,STX=>121421,ETX=>141122,EOT=>141221,ENQ=>112214,
			ACK=>112412,BEL=>122114,BS=>122411,HT=>142112,LF=>142211,VT=>241211,FF=>221114,
			CR=>413111,SO=>241112,SI=>134111,DLE=>111242,DC1=>121142,DC2=>121241,DC3=>114212,
			DC4=>124112,NAK=>124211,SYN=>411212,ETB=>421112,CAN=>421211,EM=>212141,SUB=>214121,
			ESC=>412121,FS=>111143,GS=>111341,RS=>131141,US=>114113,FNC3=>114311,FNC2=>411113,
			SHIFTB=>411311,CODEC=>113141,CODEB=>114131,FNC4=>311141,FNC1=>411131
		),
		'B'=>array(
			' '=>212222,'!'=>222122,'"'=>222221,'#'=>121223,'$'=>121322,'%'=>131222,'&'=>122213,
			'\''=>122312,'('=>132212,')'=>221213,'*'=>221312,'+'=>231212,','=>112232,'-'=>122132,
			'.'=>122231,'/'=>113222,'0'=>123122,'1'=>123221,'2'=>223211,'3'=>221132,'4'=>221231,
			'5'=>213212,'6'=>223112,'7'=>312131,'8'=>311222,'9'=>321122,':'=>321221,';'=>312212,
			'<'=>322112,'='=>322211,'>'=>212123,'?'=>212321,'@'=>232121,'A'=>111323,'B'=>131123,
			'C'=>131321,'D'=>112313,'E'=>132113,'F'=>132311,'G'=>211313,'H'=>231113,'I'=>231311,
			'J'=>112133,'K'=>112331,'L'=>132131,'M'=>113123,'N'=>113321,'O'=>133121,'P'=>313121,
			'Q'=>211331,'R'=>231131,'S'=>213113,'T'=>213311,'U'=>213131,'V'=>311123,'W'=>311321,
			'X'=>331121,'Y'=>312113,'Z'=>312311,'['=>332111,'\\'=>314111,']'=>221411,'^'=>431111,
			'_'=>111224,'`'=>111422,'a'=>121124,'b'=>121421,'c'=>141122,'d'=>141221,'e'=>112214,
			'f'=>112412,'g'=>122114,'h'=>122411,'i'=>142112,'j'=>142211,'k'=>241211,'l'=>221114,
			'm'=>413111,'n'=>241112,'o'=>134111,'p'=>111242,'q'=>121142,'r'=>121241,'s'=>114212,
			't'=>124112,'u'=>124211,'v'=>411212,'w'=>421112,'x'=>421211,'y'=>212141,'z'=>214121,
			'{'=>412121,'|'=>111143,'}'=>111341,'~'=>131141,DEL=>114113,FNC3=>114311,FNC2=>411113,
			SHIFTA=>411311,CODEC=>113141,FNC4=>114131,CODEA=>311141,FNC1=>411131
		),
		'C'=>array(
			'00'=>212222,'01'=>222122,'02'=>222221,'03'=>121223,'04'=>121322,'05'=>131222,'06'=>122213,
			'07'=>122312,'08'=>132212,'09'=>221213,'10'=>221312,'11'=>231212,'12'=>112232,'13'=>122132,
			'14'=>122231,'15'=>113222,'16'=>123122,'17'=>123221,'18'=>223211,'19'=>221132,'20'=>221231,
			'21'=>213212,'22'=>223112,'23'=>312131,'24'=>311222,'25'=>321122,'26'=>321221,'27'=>312212,
			'28'=>322112,'29'=>322211,'30'=>212123,'31'=>212321,'32'=>232121,'33'=>111323,'34'=>131123,
			'35'=>131321,'36'=>112313,'37'=>132113,'38'=>132311,'39'=>211313,'40'=>231113,'41'=>231311,
			'42'=>112133,'43'=>112331,'44'=>132131,'45'=>113123,'46'=>113321,'47'=>133121,'48'=>313121,
			'49'=>211331,'50'=>231131,'51'=>213113,'52'=>213311,'53'=>213131,'54'=>311123,'55'=>311321,
			'56'=>331121,'57'=>312113,'58'=>312311,'59'=>332111,'60'=>314111,'61'=>221411,'62'=>431111,
			'63'=>111224,'64'=>111422,'65'=>121124,'66'=>121421,'67'=>141122,'68'=>141221,'69'=>112214,
			'70'=>112412,'71'=>122114,'72'=>122411,'73'=>142112,'74'=>142211,'75'=>241211,'76'=>221114,
			'77'=>413111,'78'=>241112,'79'=>134111,'80'=>111242,'81'=>121142,'82'=>121241,'83'=>114212,
			'84'=>124112,'85'=>124211,'86'=>411212,'87'=>421112,'88'=>421211,'89'=>212141,'90'=>214121,
			'91'=>412121,'92'=>111143,'93'=>111341,'94'=>131141,'95'=>114113,'96'=>114311,'97'=>411113,
			'98'=>411311,'99'=>113141,CODEB=>114131,CODEA=>311141,FNC1=>411131
		)
	);
	public $_barCode128Values = array(
		STARTA=>103,
		STARTB=>104,
		STARTC=>105,
		STOP=>106,
		'A'=>array(
			' '=>0,'!'=>1,'"'=>2,'#'=>3,'$'=>4,'%'=>5,'&'=>6,
			'\''=>7,'('=>8,')'=>9,'*'=>10,'+'=>11,','=>12,'-'=>13,
			'.'=>14,'/'=>15,'0'=>16,'1'=>17,'2'=>18,'3'=>19,'4'=>20,
			'5'=>21,'6'=>22,'7'=>23,'8'=>24,'9'=>25,':'=>26,';'=>27,
			'<'=>28,'='=>29,'>'=>30,'?'=>31,'@'=>32,'A'=>33,'B'=>34,
			'C'=>35,'D'=>36,'E'=>37,'F'=>38,'G'=>39,'H'=>40,'I'=>41,
			'J'=>42,'K'=>43,'L'=>44,'M'=>45,'N'=>46,'O'=>47,'P'=>48,
			'Q'=>49,'R'=>50,'S'=>51,'T'=>52,'U'=>53,'V'=>54,'W'=>55,
			'X'=>56,'Y'=>57,'Z'=>58,'['=>59,'\\'=>60,']'=>61,'^'=>62,
			'_'=>63,NUL=>64,SOH=>65,STX=>66,ETX=>67,EOT=>68,ENQ=>69,
			ACK=>70,BEL=>71,BS=>72,HT=>73,LF=>74,VT=>75,FF=>76,
			CR=>77,SO=>78,SI=>79,DLE=>80,DC1=>81,DC2=>82,DC3=>83,
			DC4=>84,NAK=>85,SYN=>86,ETB=>87,CAN=>88,EM=>89,SUB=>90,
			ESC=>91,FS=>92,GS=>93,RS=>94,US=>95,FNC3=>96,FNC2=>97,
			SHIFTB=>98,CODEC=>99,CODEB=>100,FNC4=>101,FNC1=>102
		),
		'B'=>array(
			' '=>0,'!'=>1,'"'=>2,'#'=>3,'$'=>4,'%'=>5,'&'=>6,
			'\''=>7,'('=>8,')'=>9,'*'=>10,'+'=>11,','=>12,'-'=>13,
			'.'=>14,'/'=>15,'0'=>16,'1'=>17,'2'=>18,'3'=>19,'4'=>20,
			'5'=>21,'6'=>22,'7'=>23,'8'=>24,'9'=>25,':'=>26,';'=>27,
			'<'=>28,'='=>29,'>'=>30,'?'=>31,'@'=>32,'A'=>33,'B'=>34,
			'C'=>35,'D'=>36,'E'=>37,'F'=>38,'G'=>39,'H'=>40,'I'=>41,
			'J'=>42,'K'=>43,'L'=>44,'M'=>45,'N'=>46,'O'=>47,'P'=>48,
			'Q'=>49,'R'=>50,'S'=>51,'T'=>52,'U'=>53,'V'=>54,'W'=>55,
			'X'=>56,'Y'=>57,'Z'=>58,'['=>59,'\\'=>60,']'=>61,'^'=>62,
			'_'=>63,'`'=>64,'a'=>65,'b'=>66,'c'=>67,'d'=>68,'e'=>69,
			'f'=>70,'g'=>71,'h'=>72,'i'=>73,'j'=>74,'k'=>75,'l'=>76,
			'm'=>77,'n'=>78,'o'=>79,'p'=>80,'q'=>81,'r'=>82,'s'=>83,
			't'=>84,'u'=>85,'v'=>86,'w'=>87,'x'=>88,'y'=>89,'z'=>90,
			'{'=>91,'|'=>92,'}'=>93,'~'=>94,DEL=>95,FNC3=>96,FNC2=>97,
			SHIFTA=>98,CODEC=>99,FNC4=>100,CODEA=>101,FNC1=>102
		),
		'C'=>array(
			CODEB=>100,CODEA=>101,FNC1=>102
		)
	);
	
	function Code128($string) {
	
		if ($this->_debug) echo '<pre>Barcode: '.$string."\n";

		// First we need to work out what to start with!
		
		$first4 = substr($string,0,4);
		$codeAfuncs = array(NUL,SOH,STX,ETX,EOT,ENQ,ACK,BEL,BS,HT,LF,VT,FF,CR,SO,SI,DLE,DC1,DC2,DC3,DC4,NAK,SYN,ETB,CAN,EM,SUB,ESC,FS,GS,RS,US,SHIFTB,CODEB);
		$containsCodeAFuncs = false;
		for ($i=0;$i<strlen($string);$i++) {
			$char = substr($string,$i,1);
			if (in_array($char,$codeAfuncs)) $containsCodeAFuncs = true;
		}
		
		if (is_numeric($first4)) {			// Check for CodeC...first 4 characters should be digits...
			$mode = 'C';
			$barcode = $this->_barCode128Bars[STARTC];
			$sum = $this->_barCode128Values[STARTC];
			if ($this->_debug) echo "STARTC\n";
		} elseif ($containsCodeAFuncs) {	// CodeA includes functions etc, see if any of these are required...
			$mode = 'A';
			$barcode = $this->_barCode128Bars[STARTA];
			$sum = $this->_barCode128Values[STARTA];
			if ($this->_debug) echo "STARTA\n";
		} else { 							// CodeB has uppercase and lowercase letters, so this should be sufficient for most requirements...
			$mode = 'B';
			$barcode = $this->_barCode128Bars[STARTB];
			$sum = $this->_barCode128Values[STARTB];
			if ($this->_debug) echo "STARTB\n";
		}
		
		if ($this->_debug) echo "SUM:{$sum}\n";
		
		$position = 1;
		
		while (strlen($string)>0) {
		
			// If we are not in C, and the next 4 chars are numbers, we may as well switch to C...
			if ($mode!='C' && strlen($string)>=4 && is_numeric(substr($string,0,4))) {
				$barcode .= $this->_barCode128Bars[$mode][CODEC];
				if ($this->_debug) echo "CODEC\n";
				$sum += $this->_barCode128Values[$mode][CODEC]*$position;
				if ($this->_debug) echo "SUM:{$sum}\n";
				$position++;
				$mode = 'C';
			}
			
			if ($mode=='C') {
				$char = substr($string,0,2);
				$string = substr($string,2);
				if (!is_numeric($char) || strlen($char)==1) {
					// We have reached the end of the road for CODEC...
					$string = $char.$string;
					$char = substr($string,0,1);
					$string = substr($string,1);
					// We now need to choose either A or B
					$containsCodeAFuncs = false;
					for ($i=0;$i<strlen($string);$i++) {
						$testchar = substr($string,$i,1);
						if (in_array($testchar,$codeAfuncs)) $containsCodeAFuncs = true;
					}
					if ($containsCodeAFuncs) {	// We need to use CODEA
						$barcode .= $this->_barCode128Bars[$mode][CODEA];
						$sum += $this->_barCode128Values[$mode][CODEA]*$position;
						if ($this->_debug) echo "CODEA\n";
						if ($this->_debug) echo "SUM:{$sum}\n";
						$position++;
						$mode = 'A';
					} else {					// Lets use CODEB
						$barcode .= $this->_barCode128Bars[$mode][CODEB];
						$sum += $this->_barCode128Values[$mode][CODEB]*$position;
						if ($this->_debug) echo "CODEB\n";
						if ($this->_debug) echo "SUM:{$sum}\n";
						$position++;
						$mode = 'B';
					}
				}
			} else {
				$char = substr($string,0,1);
				$string = substr($string,1);
			}
			
			// Next we need to check that the Char is valid for the set we have...
			if (!array_key_exists($char, $this->_barCode128Bars[$mode])) {
				throw new Exception('Invalid Character Passed to barCode128 for subset '.$mode.' char is '.$char);
			}
			
			// Ok lets crack on!
			$barcode .= $this->_barCode128Bars[$mode][$char];
			if ($mode=='C' && !array_key_exists($char, $this->_barCode128Values[$mode])) $sum += $char*$position;
			else $sum += $this->_barCode128Values[$mode][$char]*$position;
			if ($this->_debug) echo "SUM:{$sum}\n";
			$position++;
			
			if ($this->_debug) echo "{$char}\n";
			
		}
		
		// We now need to calculate the check digit....
		$mod = $sum % 103;
		// Now we have the mod value...we need to find which character this relates to...
		// We are going to have to go backwards through the vals array to find it :(
		foreach ($this->_barCode128Values[$mode] as $key=>$val) {
			if ($val==$mod) {
				$checkChar = $key;
			}
		}
		
		if ($mode=='C' && !isset($checkChar)) {
			// Must be a number! duh!
			$checkChar = ''.$mod;
			if (strlen($checkChar)==1) $checkChar = '0'.$checkChar;
		}

		if ($this->_debug) echo "Check Digit: {$checkChar}\n";
		
		if (!isset($checkChar)) {
			throw new Exception('Unable to find check digit character for mod '.$mod.' in Subset '.$mode);
		}
		
		$barcode .= $this->_barCode128Bars[$mode][$checkChar];
		$barcode .= $this->_barCode128Bars[STOP];
		
		return $barcode;
	
	}
	
}