<?php

require_once(getcwd().'/sys/module/kicomoco/model/table.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_type.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_category.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_variation_parameter.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_image.php');

class Kicomoco_Model_Product extends Kicomoco_Model_Table {
	
	public $_table = 'tbl_product';
	public $_primaryKey = 'intId';
	public $_autoInsertField = 'intId';
	public $_urlSuffix = '.php';
	
	public function generateUrl() {
		
		return $this->getCategory()->strUrl.'/'.$this->makeSafeFilename($this->strTitle).$this->_urlSuffix;
		
	}
	
	public function getAvailableProductTypes() {
		
		$types = new Kicomoco_Model_Product_Type($this->_mysqli);
		return $types;
		
	}
	
	public function getAvailableCategories() {
		
		$categories = new Kicomoco_Model_Product_Category($this->_mysqli);
		return $categories;
		
	}
	
	public function getAvailableVariationParameters() {
		
		$parameters = new Kicomoco_Model_Product_Variation_Parameter($this->_mysqli);
		return $parameters;
		
	}
	
	public function getFirstImage() {
		
		$images = new Kicomoco_Model_Product_Image($this->_mysqli);
		$images->where('intProduct',$this->intId)
			->where('bolDeleted=0')
			->order('intOrder')
			->limit(1);
			
		if ($images->count()==1) return $images->fetch();
		
		return false;
		
	}
	
	public function getCategory() {
		
		$category = new Kicomoco_Model_Product_Category($this->_mysqli);
		$category->load($this->strCategory);
		return $category;
		
	}
	
	public function getOtherProducts() {
		
		$product = new Kicomoco_Model_Product($this->_mysqli);
		$product->where('bolDeleted=0')
			->where('intId!='.$this->intId);
		return $product;
		
	}
	
	public function getImages() {
		
		$images = new Kicomoco_Model_Product_Image($this->_mysqli);
		$images->where('intProduct',$this->intId);
		return $images;
		
	}

}