<?php

require_once(getcwd().'/sys/module/kicomoco/model/table.php');

class Kicomoco_Model_Rewrite extends Kicomoco_Model_Table {

	public $_table = 'tbl_rewrite';
	public $_primaryKey = 'strUrl';
	
	public function route() {

		$sql = 'SELECT strModule,strController,strAction,strArgs FROM tbl_rewrite WHERE strUrl=?';

		$stmt = $this->_mysqli->prepare($sql);

		if ($stmt) {

			$strUrl = $_SERVER['REQUEST_URI'];
			$intMark = strpos($strUrl,'?');
			if ($intMark) $strRequest = substr($strUrl,0,$intMark);
			else $strRequest = $strUrl;
			
			// Need to remove the SYS_PATH from the start!
			if (substr($strRequest, 0, strlen(SYS_PATH))==SYS_PATH) {
				// Ok we have the sys path at the start!
				$strRequest = substr($strRequest, strlen(SYS_PATH));
			}
			
			if (substr($strRequest,-1)=='/') $strRequest = substr($strRequest,0,-1);

			$stmt->bind_param('s',$strRequest);
			$stmt->execute();
			$stmt->store_result();
			$stmt->bind_result($strModule,$strController,$strAction,$strArgs);
			if ($stmt->num_rows==1) {

				$stmt->fetch();

				return array('strModule'=>$strModule,
					'strController'=>$strController,
					'strAction'=>$strAction,
					'strArgs'=>(is_null($strArgs) ? array() : unserialize($strArgs)),
				);

			} else {

				return false;

			}

		} else {

			throw new MySQLException('Unable to prepare SQL: '.$sql);

		}

	}

}