<?php

require_once(getcwd().'/sys/module/kicomoco_admin/controller/requireadmin.php');
require_once(getcwd().'/sys/module/kicomoco/model/page.php');
require_once(getcwd().'/sys/module/kicomoco/model/rewrite.php');

class Kicomoco_Admin_Controller_Cms extends Kicomoco_Admin_Controller_Requireadmin {
	
	public function listAction() {
	
		$pages = new Kicomoco_Model_Page($this->_mysqli);
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/cms/list.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > CMS Pages',
				'pages'=>$pages->fetchAll()
			)
		);
		
		return $return;
		
	}
	
	public function newAction() {
	
		if (count($_POST)>0) {
			
			$page = new Kicomoco_Model_Page($this->_mysqli);
			
			$page->strTitle = $_POST['title'];
			$page->strUrl = $_POST['url'];
			$page->strContent = $_POST['content'];
			$page->save();
			
			$newargs = serialize(array('url'=>$page->strUrl));
			
			$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
			$rewrite->strUrl = $page->strUrl;
			$rewrite->strModule = 'kicomoco';
			$rewrite->strController = 'page';
			$rewrite->strAction = 'page';
			$rewrite->strArgs = $newargs;
			$rewrite->save();
			
			$this->_redirect('/admin/admin/cms');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/cms/new.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > CMS Pages'
			)
		);
		
		return $return;
		
	}
	
	public function editAction() {
		
		$page = new Kicomoco_Model_Page($this->_mysqli);
		
		$page->load($_GET['url']);
		
		if (count($_POST)>0) {
		
			$oldUrl = $page->strUrl;
			
			$page->strTitle = $_POST['title'];
			$page->strUrl = $_POST['url'];
			$page->strContent = $_POST['content'];
			$page->save();
			
			// Ok, now we need to check we have a rewrite for this page...
			
			$oldargs = serialize(array('url'=>$oldUrl));
			$newargs = serialize(array('url'=>$page->strUrl));
			
			$rewrites = new Kicomoco_Model_Rewrite($this->_mysqli);
			
			$rewrites->where('strModule','kicomoco')
				->where('strController','page')
				->where('strAction','page')
				->where('strArgs',$oldargs);
				
			if ($rewrites->count()>0) {
				
				$rewrite = $rewrites->fetch();
				$rewrite->strUrl = $_POST['url'];
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			} else {
				
				// No rewrite, lets create it!
				$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
				$rewrite->strUrl = $page->strUrl;
				$rewrite->strModule = 'kicomoco';
				$rewrite->strController = 'page';
				$rewrite->strAction = 'page';
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			}
			
			$this->_redirect('/admin/admin/cms');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/cms/edit.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > CMS Pages',
				'page'=>$page
			)
		);
		
		return $return;
		
	}
	
}