<?php

require_once(getcwd().'/sys/module/kicomoco_admin/controller/requireadmin.php');
require_once(getcwd().'/sys/module/kicomoco/model/product.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_category.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_image.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_type.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_variation.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_variation_parameter.php');
require_once(getcwd().'/sys/module/kicomoco/model/product_variation_value.php');

class Kicomoco_Admin_Controller_Ecommerce extends Kicomoco_Admin_Controller_Requireadmin {
	
	public function listAction() {
	
		$product = new Kicomoco_Model_Product($this->_mysqli);
		$category = new Kicomoco_Model_Product_Category($this->_mysqli);
		$variation = new Kicomoco_Model_Product_Variation_Parameter($this->_mysqli);
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/list.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > eCommerce',
				'products'=>$product,
				'categories'=>$category,
				'variations'=>$variation
			)
		);
		
		return $return;
		
	}
	
	public function deleteproductAction() {
		
		$product = new Kicomoco_Model_Product($this->_mysqli);
		$product->load($_GET['product']);
		$product->bolDeleted = 1;
		$product->save();
		
		$this->_redirect($_SERVER['HTTP_REFERER']);
		
	}
	
	public function deleteimageAction() {
		
		$product = new Kicomoco_Model_Product_Image($this->_mysqli);
		$product->load($_GET['image']);
		$product->bolDeleted = 1;
		$product->save();
		
		$this->_redirect($_SERVER['HTTP_REFERER']);
		
	}
	
	public function deletecategoryAction() {
		
		$category = new Kicomoco_Model_Product_Category($this->_mysqli);
		$category->load($_GET['category']);
		$category->bolDeleted = 1;
		$category->save();
		
		$this->_redirect($_SERVER['HTTP_REFERER']);
		
	}
	
	public function imagesAction() {
	
		$product = new Kicomoco_Model_Product($this->_mysqli);
		$product->load($_GET['product']);
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/images.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Product Images',
				'product'=>$product
			)
		);
		
		return $return;
		
	}
	
	public function newimageAction() {
	
		$image = new Kicomoco_Model_Product_Image($this->_mysqli);
		$image->intProduct = $_GET['product'];

		if (count($_POST)>0) {
			
			$image->intOrder = $_POST['intOrder'];
			$image->save();
			
			if (isset($_FILES['strImage'])
				&& is_array($_FILES['strImage'])
				&& isset($_FILES['strImage']['tmp_name'])
				&& file_exists($_FILES['strImage']['tmp_name'])
				&& is_file($_FILES['strImage']['tmp_name'])) {

				$newName = "uploads/".$image->makeSafeFilename("product-image-{$image->intId}-{$image->getProduct()->strTitle}-{$_FILES['strImage']['name']}");
				move_uploaded_file($_FILES['strImage']['tmp_name'], $newName);
				
				$image->strImage = $newName;
				$image->save();
				
			}
						
			$this->_redirect(SYS_PATH.'admin/ecommerce/images?product='.$image->intProduct);
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editimage.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New Product Image',
				'image'=>$image,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editimageAction() {
		
		$image = new Kicomoco_Model_Product_Image($this->_mysqli);
		$image->load($_GET['image']);
		
		if (count($_POST)>0) {
						
			$image->intOrder = $_POST['intOrder'];
			$image->save();
			
			if (isset($_FILES['strImage'])
				&& is_array($_FILES['strImage'])
				&& isset($_FILES['strImage']['tmp_name'])
				&& file_exists($_FILES['strImage']['tmp_name'])
				&& is_file($_FILES['strImage']['tmp_name'])) {

				$newName = "uploads/".$image->makeSafeFilename("product-image-{$image->intId}-{$image->getProduct()->strTitle}-{$_FILES['strImage']['name']}");
				move_uploaded_file($_FILES['strCImage']['tmp_name'], $newName);
				
				$image->strImage = $newName;
				$image->save();
				
			}
									
			$this->_redirect(SYS_PATH.'admin/ecommerce/images?product='.$image->intProduct);
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editimage.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit Product Image',
				'image'=>$image,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
	public function newproductAction() {
	
		$product = new Kicomoco_Model_Product($this->_mysqli);

		if (count($_POST)>0) {
			
			$product->strTitle = $_POST['strTitle'];
			$product->dblPrice = $_POST['dblPrice'];
			$product->strPayPalBIN = $_POST['strPayPalBIN'];
			$product->strCategory = $_POST['strCategory'];
			$product->strShortDescription = $_POST['strShortDescription'];
			$product->strDescription = $_POST['strDescription'];
			$product->strFeatures = $_POST['strFeatures'];
			$product->strDetailsCare = $_POST['strDetailsCare'];
			$product->strDelivery = $_POST['strDelivery'];
			$product->strSize = $_POST['strSize'];
			$product->strUrl = $product->generateUrl();
			$product->bolAllowInOtherProducts = (isset($_POST['bolAllowInOtherProducts']) ? 1 : 0);
			$product->bolShowOnBuyNowPage = (isset($_POST['bolShowOnBuyNowPage']) ? 1 : 0);
			$product->save();
			
			$newargs = serialize(array('intProduct'=>$product->intId));
			
			$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
			$rewrite->strUrl = $product->strUrl;
			$rewrite->strModule = 'kicomoco';
			$rewrite->strController = 'ecommerce';
			$rewrite->strAction = 'product';
			$rewrite->strArgs = $newargs;
			$rewrite->save();
			
			$this->_redirect(SYS_PATH.'admin/ecommerce/images?product='.$product->intId);
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editproduct.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New Product',
				'product'=>$product,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editproductAction() {
		
		$product = new Kicomoco_Model_Product($this->_mysqli);
		
		$product->load($_GET['product']);
		
		if (count($_POST)>0) {
		
			$oldargs = serialize(array('intProduct'=>$product->intId));
			
			$product->strTitle = $_POST['strTitle'];
			$product->dblPrice = $_POST['dblPrice'];
			$product->strPayPalBIN = $_POST['strPayPalBIN'];
			$product->strCategory = $_POST['strCategory'];
			$product->strShortDescription = $_POST['strShortDescription'];
			$product->strDescription = $_POST['strDescription'];
			$product->strFeatures = $_POST['strFeatures'];
			$product->strDetailsCare = $_POST['strDetailsCare'];
			$product->strDelivery = $_POST['strDelivery'];
			$product->strSize = $_POST['strSize'];
			$product->strUrl = $product->generateUrl();
			$product->bolAllowInOtherProducts = (isset($_POST['bolAllowInOtherProducts']) ? 1 : 0);
			$product->bolShowOnBuyNowPage = (isset($_POST['bolShowOnBuyNowPage']) ? 1 : 0);
			$product->save();

			$newargs = serialize(array('intProduct'=>$product->intId));
			
			$rewrites = new Kicomoco_Model_Rewrite($this->_mysqli);
			
			$rewrites->where('strModule','kicomoco')
				->where('strController','ecommerce')
				->where('strAction','product')
				->where('strArgs',$oldargs);
				
			if ($rewrites->count()>0) {
				
				$rewrite = $rewrites->fetch();
				$rewrite->strUrl = $product->strUrl;
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			} else {
				
				// No rewrite, lets create it!
				$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
				$rewrite->strUrl = $product->strUrl;
				$rewrite->strModule = 'kicomoco';
				$rewrite->strController = 'ecommerce';
				$rewrite->strAction = 'product';
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			}
						
			$this->_redirect(SYS_PATH.'admin/ecommerce');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editproduct.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit Product',
				'product'=>$product,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
	public function newcategoryAction() {
	
		$category = new Kicomoco_Model_Product_Category($this->_mysqli);

		if (count($_POST)>0) {
			
			$category->strCategory = $_POST['strCategory'];
			$category->strSubline = $_POST['strSubline'];
			$category->strCategoryText = $_POST['strCategoryText'];
			$category->bolAlternativeListing = (isset($_POST['bolAlternativeListing']) ? $_POST['bolAlternativeListing'] : 0);
			$category->strFeatures = $_POST['strFeatures'];
			$category->strDelivery = $_POST['strDelivery'];
			$category->bolShowOnBuyNowPage = $_POST['bolShowOnBuyNowPage'];
			$category->intOrder = $_POST['intOrder'];
			$category->strUrl = $category->generateUrl();
			$category->save();
			
			if (isset($_FILES['strCategoryImage'])
				&& is_array($_FILES['strCategoryImage'])
				&& isset($_FILES['strCategoryImage']['tmp_name'])
				&& file_exists($_FILES['strCategoryImage']['tmp_name'])
				&& is_file($_FILES['strCategoryImage']['tmp_name'])) {

				$newName = "uploads/".$category->makeSafeFilename("category-{$category->intId}-{$category->strTitle}-{$_FILES['strCategoryImage']['name']}");
				move_uploaded_file($_FILES['strCategoryImage']['tmp_name'], $newName);
				
				$category->strCategoryImage = $newName;
				$category->save();
				
			}
			
			$newargs = serialize(array('strCategory'=>$category->strCategory));
			
			$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
			$rewrite->strUrl = $category->strUrl;
			$rewrite->strModule = 'kicomoco';
			$rewrite->strController = 'ecommerce';
			$rewrite->strAction = 'category';
			$rewrite->strArgs = $newargs;
			$rewrite->save();
			
			$this->_redirect(SYS_PATH.'admin/ecommerce#categories');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editcategory.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New Product Category',
				'category'=>$category,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editcategoryAction() {
		
		$category = new Kicomoco_Model_Product_Category($this->_mysqli);
		
		$category->load($_GET['category']);
		
		if (count($_POST)>0) {
			
			$oldargs = serialize(array('strCategory'=>$category->strCategory));
		
			$category->strCategory = $_POST['strCategory'];
			$category->strSubline = $_POST['strSubline'];
			$category->strCategoryText = $_POST['strCategoryText'];
			$category->bolAlternativeListing = (isset($_POST['bolAlternativeListing']) ? $_POST['bolAlternativeListing'] : 0);
			$category->strFeatures = $_POST['strFeatures'];
			$category->strDelivery = $_POST['strDelivery'];
			$category->bolShowOnBuyNowPage = $_POST['bolShowOnBuyNowPage'];
			$category->intOrder = $_POST['intOrder'];
			$category->strUrl = $category->generateUrl();
			$category->save();
			
			if (isset($_FILES['strCategoryImage'])
				&& is_array($_FILES['strCategoryImage'])
				&& isset($_FILES['strCategoryImage']['tmp_name'])
				&& file_exists($_FILES['strCategoryImage']['tmp_name'])
				&& is_file($_FILES['strCategoryImage']['tmp_name'])) {

				$newName = "uploads/".$category->makeSafeFilename("category-{$category->intId}-{$category->strTitle}-{$_FILES['strCategoryImage']['name']}");
				move_uploaded_file($_FILES['strCategoryImage']['tmp_name'], $newName);
				
				$category->strCategoryImage = $newName;
				$category->save();
				
			}
			
			$newargs = serialize(array('strCategory'=>$category->strCategory));
			
			$rewrites = new Kicomoco_Model_Rewrite($this->_mysqli);
			
			$rewrites->where('strModule','kicomoco')
				->where('strController','ecommerce')
				->where('strAction','category')
				->where('strArgs',$oldargs);
				
			if ($rewrites->count()>0) {
				
				$rewrite = $rewrites->fetch();
				$rewrite->strUrl = $category->strUrl;
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			} else {
				
				// No rewrite, lets create it!
				$rewrite = new Kicomoco_Model_Rewrite($this->_mysqli);
				$rewrite->strUrl = $category->strUrl;
				$rewrite->strModule = 'kicomoco';
				$rewrite->strController = 'ecommerce';
				$rewrite->strAction = 'category';
				$rewrite->strArgs = $newargs;
				$rewrite->save();
				
			}
			
			$this->_redirect(SYS_PATH.'admin/ecommerce#categories');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editcategory.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit Product Category',
				'category'=>$category,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}

	
	public function newvariationAction() {
	
		$variation = new Kicomoco_Model_Product_Variation_Parameter($this->_mysqli);

		if (count($_POST)>0) {
			
			$variation->strVariation = $_POST['strVariation'];
			$variation->save();
			
			$this->_redirect(SYS_PATH.'admin/ecommerce#variations');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editvariation.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > New Product Variation',
				'variation'=>$variation,
				'action'=>'new'
			)
		);
		
		return $return;
		
	}
	
	public function editvariationAction() {
		
		$variation = new Kicomoco_Model_Product_Variation_Parameter($this->_mysqli);
		
		$variation->load($_GET['variation']);
		
		if (count($_POST)>0) {
		
			$variation->strVariation = $_POST['strVariation'];
			$variation->save();
			
			$this->_redirect(SYS_PATH.'admin/ecommerce#variations');
			exit;
			
		}
		
		$return = array(
			'basics'=>$this->fetchBasics(),
			'layout'=>'admin/template.tpl',
			'template'=>'admin/ecommerce/editvariation.tpl',
			'args'=>array(
				'title'=>SITE_NAME.' Admin > Edit Product Variation',
				'variation'=>$variation,
				'action'=>'edit'
			)
		);
		
		return $return;
		
	}
	
}