<!-- light-blue - v3.0.0 - 2014-11-11 -->

<!DOCTYPE html>
<html>
<head>
    <title>{$title}</title>

    <link href="{$smarty.const.SYS_PATH}skin/admin/css/application.css" rel="stylesheet">
    <link href="{$smarty.const.SYS_PATH}skin/admin/css/haygain.css" rel="stylesheet">
    <link rel="shortcut icon" href="{$smarty.const.SYS_PATH}skin/admin/img/favicon.png">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta charset="utf-8">
    <script>
        /* yeah we need this empty stylesheet here. It's cool chrome & chromium fix
           chrome fix https://code.google.com/p/chromium/issues/detail?id=167083
                      https://code.google.com/p/chromium/issues/detail?id=332189
        */
    </script>
</head>
<body class="background-dark{foreach from=$basics.bodyclasses item=class} {$class}{/foreach}">
        <div class="single-widget-container">
            <section class="widget login-widget">
                <header class="text-align-center">
                    <h4>Login to your account</h4>
                </header>
                <div class="body">
                    <form class="no-margin"
                          action="{$smarty.const.SYS_PATH}admin/login" method="post">
                        <fieldset>
                            <div class="form-group">
                                <label for="email" >Email</label>
                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-user"></i>
                                    </span>
                                    <input id="email" type="text" name="strEmail" class="form-control input-lg input-transparent"
                                           placeholder="Your Email">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="password" >Password</label>

                                <div class="input-group input-group-lg">
                                    <span class="input-group-addon">
                                        <i class="fa fa-lock"></i>
                                    </span>
                                    <input id="password" type="password" name="strPassword" class="form-control input-lg input-transparent"
                                           placeholder="Your Password">
                                </div>
                            </div>
                        </fieldset>
                        <div class="form-actions" style="padding-bottom: 20px;">
                            <button type="submit" class="btn btn-block btn-lg btn-danger">
                                <span class="small-circle"><i class="fa fa-caret-right"></i></span>
                                <small>Sign In</small>
                            </button>
                            <!--<a class="forgot" href="#">Forgot Username or Password?</a>-->
                        </div>
                    </form>
                </div>
            </section>
        </div>
        
<!-- common libraries. required for every page-->
<script src="{$smarty.const.SYS_PATH}skin/admin/lib/jquery/dist/jquery.min.js"></script>
<script src="{$smarty.const.SYS_PATH}skin/admin/lib/jquery-pjax/jquery.pjax.js"></script>
<script src="{$smarty.const.SYS_PATH}skin/admin/lib/bootstrap-sass-official/assets/javascripts/bootstrap.js"></script>
<script src="{$smarty.const.SYS_PATH}skin/admin/lib/widgster/widgster.js"></script>
<script src="{$smarty.const.SYS_PATH}skin/admin/lib/underscore/underscore.js"></script>

<!-- common application js -->
<script src="{$smarty.const.SYS_PATH}skin/admin/js/app.js"></script>
<script src="{$smarty.const.SYS_PATH}skin/admin/js/settings.js"></script>

<!-- common templates -->
<script type="text/template" id="settings-template">
    <div class="setting clearfix">
        <div>Background</div>
        <div id="background-toggle" class="pull-left btn-group" data-toggle="buttons-radio">
            <% dark = background == 'dark'; light = background == 'light';%>
            <button type="button" data-value="dark" class="btn btn-sm btn-default <%= dark? 'active' : '' %>">Dark</button>
            <button type="button" data-value="light" class="btn btn-sm btn-default <%= light? 'active' : '' %>">Light</button>
        </div>
    </div>
    <div class="setting clearfix">
        <div>Sidebar on the</div>
        <div id="sidebar-toggle" class="pull-left btn-group" data-toggle="buttons-radio">
            <% onRight = sidebar == 'right'%>
            <button type="button" data-value="left" class="btn btn-sm btn-default <%= onRight? '' : 'active' %>">Left</button>
            <button type="button" data-value="right" class="btn btn-sm btn-default <%= onRight? 'active' : '' %>">Right</button>
        </div>
    </div>
    <div class="setting clearfix">
        <div>Sidebar</div>
        <div id="display-sidebar-toggle" class="pull-left btn-group" data-toggle="buttons-radio">
            <% display = displaySidebar%>
            <button type="button" data-value="true" class="btn btn-sm btn-default <%= display? 'active' : '' %>">Show</button>
            <button type="button" data-value="false" class="btn btn-sm btn-default <%= display? '' : 'active' %>">Hide</button>
        </div>
    </div>
    <div class="setting clearfix">
        <div>White Version</div>
        <div>
            <a data-toggle="modal" data-target="#white-temp" class="btn btn-sm btn-default">&nbsp; Switch &nbsp;   <i class="fa fa-angle-right"></i></a>
        </div>
    </div>
</script>

{literal}
<script type="text/template" id="sidebar-settings-template">
    <% auto = sidebarState == 'auto'%>
    <% if (auto) {%>
    <button type="button"
            data-value="icons"
            class="btn-icons btn btn-transparent btn-sm">Icons</button>
    <button type="button"
            data-value="auto"
            class="btn-auto btn btn-transparent btn-sm">Auto</button>
    <%} else {%>
    <button type="button"
            data-value="auto"
            class="btn btn-transparent btn-sm">Auto</button>
    <% } %>
</script>
{/literal}

</body>
</html>